<?xml version="1.0" encoding="UTF-8"?>
<!-- 
	NAME: Expanded outline v2.43.xsl
    LAST MODIFIED: 7/25/08
    
    PURPOSE: To transform an InfoML 0.88 document into a text file formatted as
        a rudimentary outline. This file is to be used with Infocard Organizer's
        Export function. Works with version 070813 of Infocard Organizer.
    
    BUGS:
    
    * none known; probably crashes if input file is invalid
    
    NOTES:
    
    * This program can be used as a template for XSLT transformations that
    visit every infocard in the order that they display in when viewed by
    Infocard Organizer. Change the section below marked "CASE 1" to specify
    how each infocard in turn is processed. The infocard currently being
    examined is in the variable $make. For example,
    
    * This transformation assumes that the first infoml element in the file
    contains nothing but a list of pointers to the top-level infocards. This
    is part of the design that enables an infocard file to represent either a
    list of infocards or an outline.
    
    * This transformation was designed to work with XSLT V1.0. It *IS*
    namespace-aware.    
-->

<!DOCTYPE stylesheet [
<!ENTITY nbsp  "&#160;" ><!-- non-breaking space -->
]>


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:q="http://infoml.org/infomlFile" version="2.0">
	<xsl:variable name="spaces"
		>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:variable>
	<xsl:variable name="spacesArray"
		select="concat(concat(concat($spaces,$spaces),$spaces),$spaces)"/>
	<xsl:variable name="indentIncrement" select="number(4)"/>
	
	<xsl:output media-type="text" omit-xml-declaration="yes"/>
	
	
		
	<xsl:template match="q:infomlFile">
		<xsl:apply-templates/>
	</xsl:template>
	
	
	<!-- the following template is for debugging only -->
	<!--    
        <xsl:template match="*" priority="-10">
        <xsl:text>&#10;</xsl:text>
        <xsl:text>CONTENT UNACCOUNTED FOR:</xsl:text>
        <xsl:value-of select="name()"/>
    </xsl:template>
-->
	
	
	
	<!-- This forces processor to ignore all infoml elements (except first one, as
		defined by the next template (below) -->
	<xsl:template match="q:infoml"/>
	
	<!-- This forces processor to process first infoml element. It begins by calling
		the "recurse" template on the root infoml element. -->
	<xsl:template match="//q:infoml[1]">
		<xsl:variable name="var" select="namespace-uri()"/>
		<xsl:call-template name="recurse">
			<xsl:with-param name="node" select="."/>
			<xsl:with-param name="level" select="-1"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- the "recurse" template -->
	<!-- Arguments: $node = node to be printed -->
	<!--     $indentString = contains spaces only; used to create indentation -->
	<xsl:template name="recurse">
		<xsl:param name="node"/>
		<xsl:param name="level"/>
		
		<!-- indentString is the amount of indentation needed -->
		<xsl:variable name="indentSizeValue"
			select="number($level * $indentIncrement)"/>
		<xsl:variable name="indentString"
			select="substring($spacesArray, 1, $indentSizeValue)"/>
		
		<xsl:choose>
			<!-- CASE 1: This is a leaf node; print it, with indentation -->
			<xsl:when test="$node//q:title">
				<!-- (1) -->
				<xsl:value-of select="$indentString"/>
				<xsl:text>* </xsl:text>
				<xsl:value-of select="normalize-space($node//q:title/text())"/>
				<xsl:text>&#10;</xsl:text>
			</xsl:when>

			<xsl:otherwise>
				
				<!-- CASE 2: This is a group node, with parent and child nodes -->
				<xsl:choose>
					<!-- (1) Test if node is a valid group node -->
					<xsl:when test="($node//q:parentPtr) or ($node//q:ptr)">
						<xsl:choose>
							<!-- Follow parentPtr (if any) to print the node it points to. -->
							<!-- parentNode is the actual infoml element to be printed. -->
							<xsl:when test="$node//q:parentPtr">
								<xsl:variable name="idOfParentNode"
									select="string ($node//q:parentPtr/@targetId)"/>
								<xsl:variable name="parentNode"
									select="//q:infoml [@cardId = $idOfParentNode]"/>
								<xsl:call-template name="recurse">
									<xsl:with-param name="node" select="$parentNode"/>
									<xsl:with-param name="level" select="$level"/>
								</xsl:call-template>
							</xsl:when>
						</xsl:choose>

						<!-- Follow ptr to print the (child) node, indented to the right. -->
						<!-- childNode is the actual infoml element to be processed; recursion is necessary
				             because childNode may itself be a parent/child pointer node. -->
						<xsl:for-each select="$node//q:ptr">
							<xsl:variable name="idOfChildNode"
								select="string (@targetId)"/>
							<xsl:variable name="childNode"
								select="//q:infoml [@cardId = $idOfChildNode]"/>
							<xsl:variable name="beginNode"
								select="/q:infomlFile/q:infoml [1]"/>
							<xsl:choose>
								<!-- In this case, TRUE and FALSE branches, below, are the same. -->
								<!-- XSL files derived from this one may need to treat -->
								<!-- beginNode differently. -->
								<xsl:when test="$node = $beginNode">
									<xsl:call-template name="recurse">
										<xsl:with-param name="node" select="$childNode"/>
										<xsl:with-param name="level" select="1 + $level"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="recurse">
										<xsl:with-param name="node" select="$childNode"/>
										<xsl:with-param name="level" select="1 + $level"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>

					</xsl:when>
					
					<!-- node should be but is not a group node; see (1) -->
					<xsl:otherwise>
						<xsl:text>ERROR: expected node with parentPtr and/or ptr</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>
	
	
	<!-- This template "gobbles up" all text elements found between elements (mostly Return characters). -->
	<xsl:template match="text()"/>
	


</xsl:stylesheet>
